/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.upgrddat;

import com.ibm.hwmca.base.settings.network.NetworkSettings;
import com.ibm.hwmca.base.upgrddat.UpgradeDataClassFilter;
import com.ibm.hwmca.base.upgrddat.UpgradeDataConstants;
import com.ibm.hwmca.base.upgrddat.UpgradeDataErrorIds;
import com.ibm.hwmca.base.upgrddat.UpgradeDataFilter;
import com.ibm.hwmca.base.upgrddat.UpgradeDataRestoreOS2;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.Tower;
import com.ibm.hwmca.fw.mediasvc.MediaDevice;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceException;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceIdentifier;
import com.ibm.hwmca.fw.mediasvc.MediaDeviceLockException;
import com.ibm.hwmca.fw.mediasvc.MediaServices;
import com.ibm.hwmca.fw.mediasvc.MediaWriteProtectedException;
import com.ibm.hwmca.fw.mediasvc.NoMediaPresentException;
import com.ibm.hwmca.fw.system.StartupHook;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.upgrddat.UpgradeData;
import com.ibm.hwmca.fw.upgrddat.UpgradeDataException;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class UpgradeDataRestoreTasklet
extends StartupHook
implements UpgradeDataErrorIds,
UpgradeDataConstants {
    private static final String RES_BUNDLE_NAME = "com.ibm.hwmca.base.res.message";
    private static final String INTERFACE_NAME = "com.ibm.hwmca.fw.upgrddat.UpgradeData";
    private static final String TRACE_MASKT = "XSAVRTRT";
    private static final String TRACE_MASKF = "XSAVRTRF";
    private static final String TRACE_MASKD = "XSAVRTRD";
    public static final String PANEL_TITLE = "SAV80008";
    public static final String BUSY_MSG1 = "SAV80007";
    public static final String BUSY_MSG2 = "SAV80014";
    private String filePrefix = "UpgradeData.";
    private List implList = null;
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(3, "UpgradeDataRestoreTasklet");
    MediaDevice upgrDeviceHD = null;
    static MediaDevice upgrDeviceDOS = null;
    MediaDevice upgrDeviceDVD = null;
    boolean restore_lst = false;
    boolean good_completion = false;

    public UpgradeDataRestoreTasklet(PanelTasklet theTasklet) {
        super(theTasklet);
        Trace.trace(TRACE_MASKT, "<> UpgradeDataRestoreTasklet constructor");
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataRestoreTasklet.service()");
        if (taskletRequest.isInitialRequest()) {
            Trace.trace(TRACE_MASKF, "-> UpgradeDataRestoreTasklet.isInitialRequest()");
            Trace.trace(TRACE_MASKF, "<- UpgradeDataRestoreTasklet.isInitialRequest()");
        }
        Trace.trace(TRACE_MASKF, "Call restoreUpgradeData() method");
        this.restoreUpgradeDataTasklet();
        Trace.trace(TRACE_MASKF, "Return from restoreUpgradeData() method call");
        if (this.good_completion && this.restore_lst) {
            Trace.trace(TRACE_MASKF, "Restart HMC Application");
            this.finished(3);
        } else {
            Trace.trace(TRACE_MASKF, "Continue with HMC Application");
            this.finished(1);
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataRestoreTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.logException()");
        Trace.trace(TRACE_MASKT, "processing exception: " + throwable);
        HException hexc = new HException(throwable);
        new FrameworkLog(_logInfo, 16466, hexc).log();
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.logException()");
    }

    public void restoreupgradeMessages(int message) {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.restoreupgradeMessages(int message)");
        int choice = message;
        MessageText[] text = new BaseMessageText[1];
        BaseMessageTitle title = null;
        String msgId = null;
        try {
            switch (choice) {
                case 3: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not ready panel");
                    title = new BaseMessageTitle("SAV80003");
                    text[0] = new BaseMessageText("SAV00003E");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not ready panel");
                    break;
                }
                case 4: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD write protected panel");
                    title = new BaseMessageTitle("SAV80004");
                    text[0] = new BaseMessageText("SAV00004E");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD write protected panel");
                    break;
                }
                case 7: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not supported panel");
                    title = new BaseMessageTitle(PANEL_TITLE);
                    text[0] = new BaseMessageText("SAV00007I");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not supported panel");
                    break;
                }
                case 8: {
                    Trace.trace(TRACE_MASKF, "Do setup for DVD not functional panel");
                    title = new BaseMessageTitle(PANEL_TITLE);
                    text[0] = new BaseMessageText("SAV00008I");
                    Trace.trace(TRACE_MASKF, "Setup complete for DVD not functional panel");
                    break;
                }
                case 10: {
                    Trace.trace(TRACE_MASKF, "Do setup for media device locked panel");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00010I");
                    Trace.trace(TRACE_MASKF, "Setup complete for media device locked panel");
                    break;
                }
                case 11: {
                    Trace.trace(TRACE_MASKF, "Do setup for wrong DVD label panel");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00011I");
                    Trace.trace(TRACE_MASKF, "Setup complete for wrong DVD label panel");
                    break;
                }
                case 12: {
                    Trace.trace(TRACE_MASKF, "Do setup for error mounting upgrade partition panel");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00012E");
                    Trace.trace(TRACE_MASKF, "Setup complete for error mounting upgrade partition panel");
                    break;
                }
                case 13: {
                    Trace.trace(TRACE_MASKF, "Do setup for Restore to HardDrive Successfully Panel");
                    title = new BaseMessageTitle("SAV80009");
                    text[0] = new BaseMessageText("SAV00013I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Restore to HardDrive Successfully Panel");
                    break;
                }
                case 14: {
                    Trace.trace(TRACE_MASKF, "Do setup for not all data restored panel");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00014I");
                    Trace.trace(TRACE_MASKF, "Setup complete for not all data restored panel");
                    break;
                }
                case 15: {
                    Trace.trace(TRACE_MASKF, "Do setup for Error occurred message");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00015E");
                    Trace.trace(TRACE_MASKF, "Setup complete for Error restoring to media panel");
                    break;
                }
                case 16: {
                    Trace.trace(TRACE_MASKF, "Do setup for No saved data found for restore.");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00016E");
                    Trace.trace(TRACE_MASKF, "Setup complete for No saved data found for restore ");
                    break;
                }
                case 17: {
                    Trace.trace(TRACE_MASKF, "Do setup for Restore.lst does not have vaid data.");
                    title = new BaseMessageTitle("SAV8000A");
                    text[0] = new BaseMessageText("SAV00017I");
                    Trace.trace(TRACE_MASKF, "Setup complete for Restore.lst does not have vaild data.");
                    break;
                }
                default: {
                    HException hexc = new HException("Unknown error");
                    Trace.trace(TRACE_MASKF, hexc);
                    Trace.trace(TRACE_MASKF, "Return code from Server does not match message box case number." + hexc);
                    new FrameworkLog(_logInfo, 16467, hexc).log();
                    break;
                }
            }
            Trace.trace(TRACE_MASKF, "message to be displayed is : " + text[0].toString());
            this.tasklet.showMessageBox(false, title, text, msgId, null, null);
        }
        catch (Exception exc) {
            HException hexc = new HException(exc);
            Trace.trace(TRACE_MASKF, "Caught Excecption in restoreupgradeMessages(int message)" + exc);
            new FrameworkLog(_logInfo, 16468, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.restoreupgradeMessages(int message)");
    }

    public int mountHardDrive() {
        int mountHD_error = 0;
        String mount_harddrive = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.mountHardDrive()");
        try {
            Trace.trace(TRACE_MASKF, "Create class MediaServices");
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier upgrMediaId = ms.getPreferredDevice(4);
            this.upgrDeviceHD = ms.requestLock(new LocalizableText("Save Upgrade Data Hard Drive"), upgrMediaId);
            Trace.trace(TRACE_MASKF, "Mount read write HardDrive");
            this.upgrDeviceHD.mountReadWrite();
            Trace.trace(TRACE_MASKF, "Read write HardDrive mounted");
            Trace.trace(TRACE_MASKF, "Get mount point of HardDrive");
            mount_harddrive = this.upgrDeviceHD.getMountPoint().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "mount_harddrive mount point is = " + mount_harddrive);
            String upgradePath = BaseFileControl.getFilePath("UpgradeDataAllTowers.zip");
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            File f1 = new File(upgradePath);
            if (f1.exists()) {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
            } else {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "does not exist create it");
                f1.mkdirs();
                if (f1.exists()) {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                } else {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "was not created");
                }
            }
            Trace.trace(TRACE_MASKF, "mount_harddrive is = " + mount_harddrive);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16469, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 10;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16471, e).log();
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16472, e).log();
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 12;
            new FrameworkLog(_logInfo, 16470, e).log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDrive.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16473, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.mountHardDrive()");
        return mountHD_error;
    }

    public int mountDVD() {
        int mountDVD_error = 0;
        String mount_dvd = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.mountDVD()");
        try {
            Trace.trace(TRACE_MASKF, "Before creating class mediaServices");
            MediaServices msDVD = MediaServices.getMediaServices();
            Trace.trace(TRACE_MASKF, "After creating class mediaServices");
            MediaDeviceIdentifier upgrMediaIdDVD = msDVD.getPreferredDevice(6);
            this.upgrDeviceDVD = msDVD.requestLock(new LocalizableText("Save Upgrade Data DVD Drive"), upgrMediaIdDVD);
            Trace.trace(TRACE_MASKT, "<-> Get DVD label");
            String label_DVD = this.upgrDeviceDVD.getLabel();
            Trace.trace(TRACE_MASKT, "<-> DVD is : " + label_DVD);
            if (!this.upgrDeviceDVD.getLabel().equals("ACTBKP")) {
                throw new MediaDeviceException("wrong label");
            }
            Trace.trace(TRACE_MASKF, "Mount DVD read Only");
            this.upgrDeviceDVD.mountReadOnly();
            Trace.trace(TRACE_MASKF, "DVD mounted read Only");
            Trace.trace(TRACE_MASKF, "Get DVD mount point");
            mount_dvd = this.upgrDeviceDVD.getMountPoint().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "Mount point DVD is :" + mount_dvd);
            String upgradePath = this.upgrDeviceDVD.getMountPoint().getAbsolutePath() + "/uplinux/";
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            File f1DVD = new File(upgradePath);
            if (f1DVD.exists()) {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
            } else {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "does not exist create it");
                f1DVD.mkdirs();
                if (f1DVD.exists()) {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                } else {
                    Trace.trace(TRACE_MASKF, "Path " + upgradePath + "was not created");
                }
            }
            Trace.trace(TRACE_MASKF, "mount_dvd is = " + mount_dvd);
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet get label DVD");
            label_DVD = this.upgrDeviceDVD.getLabel();
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet label is : " + label_DVD);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet.mountDVD.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 15;
            new FrameworkLog(_logInfo, 16474, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet.mountDVD.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 10;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet.mountDVD.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 4;
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet.mountDVD.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 3;
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet.mountDVD.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            if (e.getMessage().equals("wrong label")) {
                mountDVD_error = 11;
            } else {
                mountDVD_error = 8;
                new FrameworkLog(_logInfo, 16475, e).log();
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataRestoreTasklet.mountDVD.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountDVD_error = 15;
            new FrameworkLog(_logInfo, 16476, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataRestoreTasklet.mountDVD()");
        return mountDVD_error;
    }

    public static int mountHardDriveDOS() {
        int mountHD_error = 0;
        String mount_harddriveDOS = null;
        MediaDeviceIdentifier upgrMediaId = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.mountHardDriveDOS()");
        try {
            Trace.trace(TRACE_MASKF, "Create class MediaServices");
            MediaServices ms = MediaServices.getMediaServices();
            MediaDeviceIdentifier[] mdis = ms.getMediaDeviceIdentifiers(4);
            if (mdis.length > 1) {
                Trace.trace(TRACE_MASKF, "There are at least 2 hard drive partitions");
                for (int i = 0; i < mdis.length; ++i) {
                    if (!mdis[i].getDeviceName().equals("dos")) continue;
                    Trace.trace(TRACE_MASKF, "Drive " + mdis[i] + " found");
                    Trace.trace(TRACE_MASKF, mdis[i]);
                    upgrMediaId = mdis[i];
                }
                if (upgrMediaId == null) {
                    Trace.trace(TRACE_MASKF, "upgrMediaId DOS is null");
                    upgrMediaId = ms.getPreferredDevice(1);
                }
            } else {
                Trace.trace(TRACE_MASKF, "There is only 1 hard drive partition");
                upgrMediaId = ms.getPreferredDevice(1);
            }
            upgrDeviceDOS = ms.requestLock(new LocalizableText("Save Upgrade Data Hard Drive DOS"), upgrMediaId);
            Trace.trace(TRACE_MASKF, "Mount DOS read write HardDrive");
            upgrDeviceDOS.mountReadWrite();
            Trace.trace(TRACE_MASKF, "DOS Read write HardDrive mounted");
            Trace.trace(TRACE_MASKF, "Get mount point of DOS HardDrive");
            mount_harddriveDOS = upgrDeviceDOS.getMountPoint().getAbsolutePath();
            Trace.trace(TRACE_MASKF, "DOS mount_harddrive mount point is = " + mount_harddriveDOS);
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDriveDOS.IllegalArgumentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16477, e).log();
        }
        catch (MediaDeviceLockException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDriveDOS.MediaDeviceLockException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 10;
        }
        catch (MediaWriteProtectedException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDriveDOS.MediaWriteProtectedException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16479, e).log();
        }
        catch (NoMediaPresentException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDriveDOS.NoMediaPresentException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16480, e).log();
        }
        catch (MediaDeviceException e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDriveDOS.MediaDeviceException");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 12;
            new FrameworkLog(_logInfo, 16478, e).log();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.mountHardDriveDOS.Exception");
            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
            mountHD_error = 15;
            new FrameworkLog(_logInfo, 16481, e).log();
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.mountHardDriveDOS()");
        return mountHD_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void restoreUpgradeDataTasklet() {
        int message;
        block72: {
            int mount_error;
            block73: {
                String mount_pointDOS;
                block71: {
                    Trace.trace(TRACE_MASKT, "-> UpgradeDataRestore.RestoreUpgradeDataTasklet()");
                    String upgrade_type = "None";
                    mount_error = 0;
                    message = 13;
                    mount_pointDOS = null;
                    Trace.trace(TRACE_MASKF, "Mount the DOS partition.");
                    mount_error = UpgradeDataRestoreTasklet.mountHardDriveDOS();
                    Trace.trace(TRACE_MASKF, "mount_error is : " + mount_error);
                    if (mount_error != 0) break block73;
                    Trace.trace(TRACE_MASKF, "Get mount point of DOS HardDrive");
                    mount_pointDOS = upgrDeviceDOS.getMountPoint().getAbsolutePath();
                    Trace.trace(TRACE_MASKF, "DOS mount_harddrive mount point is = " + mount_pointDOS);
                    String upgradePath = mount_pointDOS + "/linos2/" + "restore.lst";
                    Trace.trace(TRACE_MASKF, "UpgradePath is :" + mount_pointDOS);
                    File f1DOS = new File(upgradePath);
                    if (f1DOS.exists()) {
                        String mount_pointHD;
                        Trace.trace(TRACE_MASKF, "File " + upgradePath + " exists");
                        this.restore_lst = true;
                        Trace.trace(TRACE_MASKF, "Create busy dialog box");
                        LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                        LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG1);
                        this.tasklet.showBusyDialog(title, msg);
                        BufferedReader in = new BufferedReader(new FileReader(upgradePath));
                        String line = null;
                        Object newFileName = null;
                        line = in.readLine();
                        if (line != null) {
                            if ((line = line.trim()).length() > 0) {
                                Trace.trace(TRACE_MASKF, "Line is " + line);
                                upgrade_type = line;
                                StringTokenizer parser = new StringTokenizer(upgrade_type);
                                int token_count = parser.countTokens();
                                if (token_count == 1) {
                                    Trace.trace(TRACE_MASKF, "Token count is " + token_count);
                                    if (upgrade_type.equals("HARDDRIVE")) {
                                        Trace.trace(TRACE_MASKF, "Restore.lst Data is HARDRIVE");
                                    } else if (upgrade_type.equals("DVD")) {
                                        Trace.trace(TRACE_MASKF, "Restore.lst Data is DVD");
                                    } else if (upgrade_type.equals("OS2")) {
                                        Trace.trace(TRACE_MASKF, "Restore.lst Data is OS2");
                                    } else {
                                        Trace.trace(TRACE_MASKF, "Restore.lst data not known");
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "More than one token ");
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "Error -- Line length is : " + line.length());
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "Error Line is null -- Restore.lst contains : " + line);
                            upgrade_type = "null";
                        }
                        Trace.trace(TRACE_MASKF, "Close restore.lst file");
                        in.close();
                        if (upgrade_type.equals("DVD")) {
                            do {
                                mount_error = 0;
                                mount_error = this.mountDVD();
                                Trace.trace(TRACE_MASKF, "mount_error is : " + mount_error);
                            } while (mount_error == 3 || mount_error == 4 || mount_error == 10 || mount_error == 11);
                            if (mount_error == 0) {
                                Trace.trace(TRACE_MASKF, "Get mount point of DVD");
                                String mount_pointDVD = this.upgrDeviceDVD.getMountPoint().getAbsolutePath();
                                Trace.trace(TRACE_MASKF, "DVD mount point is = " + mount_pointDVD);
                                upgradePath = mount_pointDVD + "/uplinux/" + "UpgradeDataAllTowers.zip";
                                f1DOS = new File(upgradePath);
                                if (f1DOS.exists()) {
                                    mount_error = 0;
                                    mount_error = this.mountHardDrive();
                                    if (mount_error == 0) {
                                        try {
                                            int count;
                                            String fileRead = this.upgrDeviceDVD.getMountPoint().getAbsolutePath() + "/uplinux/" + "UpgradeDataAllTowers.zip";
                                            Trace.trace(TRACE_MASKF, "fileRead is : " + fileRead);
                                            String fileWrite = this.upgrDeviceHD.getMountPoint().getAbsolutePath() + "/uplinux/" + "UpgradeDataAllTowers.zip";
                                            Trace.trace(TRACE_MASKF, "fileWrite is : " + fileWrite);
                                            FileInputStream in_stream = new FileInputStream(fileRead);
                                            FileOutputStream out_stream = new FileOutputStream(fileWrite);
                                            byte[] buf = new byte[1024];
                                            while ((count = in_stream.read(buf)) > 0) {
                                                out_stream.write(buf, 0, count);
                                            }
                                            in_stream.close();
                                            out_stream.close();
                                            if (this.upgrDeviceDVD != null) {
                                                Trace.trace(TRACE_MASKF, "DVD partition Unmount DVD partition");
                                                this.upgrDeviceDVD.unmount();
                                                this.upgrDeviceDVD.unlock();
                                                this.upgrDeviceDVD = null;
                                                Trace.trace(TRACE_MASKF, "DVD partition Unmount DVD partition completed");
                                            }
                                            int return_status = 0;
                                            Trace.trace(TRACE_MASKF, "Call restoreupgradeHarddrive()");
                                            return_status = this.restoreupgradeHarddrive();
                                            Trace.trace(TRACE_MASKF, "Return from restoreupgradeHarddrive()");
                                            Trace.trace(TRACE_MASKF, "Return status is = " + return_status);
                                            if (return_status != 0) {
                                                Trace.trace(TRACE_MASKF, "Set message to " + return_status);
                                                message = return_status;
                                            }
                                        }
                                        catch (IOException e) {
                                            Trace.trace(TRACE_MASKF, "IOException on writing of file  to harddrive");
                                            Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                                            HException hexc = new HException(e);
                                            Trace.trace(TRACE_MASKF, "Caught IOException writing to DVD");
                                            message = 15;
                                            new FrameworkLog(_logInfo, 16482, hexc).log();
                                        }
                                    } else {
                                        Trace.trace(TRACE_MASKF, "In DVD. Error mounting HardDrive partition");
                                        message = mount_error;
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                                    message = 16;
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "Error mounting DVD");
                                message = mount_error;
                            }
                        } else if (upgrade_type.equals("HARDDRIVE")) {
                            mount_error = 0;
                            mount_error = this.mountHardDrive();
                            Trace.trace(TRACE_MASKF, "mount_error is : " + mount_error + " from hard drive");
                            if (mount_error == 0) {
                                Trace.trace(TRACE_MASKF, "Get mount point of Hard Drive");
                                mount_pointHD = this.upgrDeviceHD.getMountPoint().getAbsolutePath();
                                Trace.trace(TRACE_MASKF, "Hard Drive mount point is = " + mount_pointHD);
                                upgradePath = mount_pointHD + "/uplinux/" + "UpgradeDataAllTowers.zip";
                                Trace.trace(TRACE_MASKF, "upgradePath is " + upgradePath);
                                f1DOS = new File(upgradePath);
                                if (f1DOS.exists()) {
                                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " does exist");
                                    int return_status = 0;
                                    Trace.trace(TRACE_MASKF, "Call restoreupgradeHarddrive()");
                                    return_status = this.restoreupgradeHarddrive();
                                    Trace.trace(TRACE_MASKF, "Return status is = " + return_status);
                                    if (return_status != 0) {
                                        Trace.trace(TRACE_MASKF, "Set message to " + return_status);
                                        message = return_status;
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                                    message = 16;
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "Error mounting HardDrive partition");
                            }
                        } else if (upgrade_type.equals("OS2")) {
                            upgradePath = mount_pointDOS + "/linos2/" + "save.lst";
                            f1DOS = new File(upgradePath);
                            if (f1DOS.exists()) {
                                Trace.trace(TRACE_MASKF, "DOS call File " + upgradePath + " exists");
                                mount_error = 0;
                                mount_error = this.mountHardDrive();
                                Trace.trace(TRACE_MASKF, "DOS call mount_error is : " + mount_error + " from hard drive");
                                if (mount_error == 0) {
                                    Trace.trace(TRACE_MASKF, "DOS call good mount of Hard Drive");
                                    mount_pointHD = this.upgrDeviceHD.getMountPoint().getAbsolutePath();
                                    Trace.trace(TRACE_MASKF, "Hard Drive mount point is = " + mount_pointHD);
                                    File dosos2path = new File(mount_pointDOS + "/linos2/");
                                    Trace.trace(TRACE_MASKF, "dosos2path is = " + dosos2path);
                                    File upgradeos2path = new File(mount_pointHD);
                                    Trace.trace(TRACE_MASKF, "upgradeos2path is = " + upgradeos2path);
                                    File upgradelinos2path = new File(mount_pointHD + "/linos2/");
                                    if (upgradelinos2path.exists()) {
                                        Trace.trace(TRACE_MASKF, upgradelinos2path + " exists ");
                                        FileUtilities.delete(upgradeos2path + "/linos2/");
                                    } else {
                                        Trace.trace(TRACE_MASKF, upgradelinos2path + " does not exist");
                                    }
                                    FileUtilities.copy(dosos2path, upgradeos2path);
                                    UpgradeDataRestoreOS2 restore = new UpgradeDataRestoreOS2();
                                    int return_status = 0;
                                    Trace.trace(TRACE_MASKF, "Call restoreOS2UpgradeData()");
                                    return_status = restore.restoreOS2UpgradeData();
                                    Trace.trace(TRACE_MASKF, "Return from restoreOs2UpgradeData()");
                                    Trace.trace(TRACE_MASKF, "Return status is = " + return_status);
                                    if (return_status != 0) {
                                        Trace.trace(TRACE_MASKF, "Set message to " + return_status);
                                        message = return_status;
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "DOS call Error mounting HardDrive partition");
                                }
                            } else {
                                Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                                message = 16;
                            }
                        } else {
                            Trace.trace(TRACE_MASKF, "Error- Restore.lst File contains " + upgrade_type);
                            message = 17;
                        }
                        Trace.trace(TRACE_MASKF, "About to destroy busy dialog box");
                        Thread.currentThread();
                        Thread.sleep(5000L);
                        this.tasklet.destroyBusyDialog();
                        break block71;
                    }
                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                }
                Object var21_31 = null;
                Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataRestoreTasklet.restoreUpgradeData()");
                try {
                    if (message == 13 && this.restore_lst) {
                        Trace.trace(TRACE_MASKF, "Good completion. Now merge network settings ");
                        NetworkSettings.getNetworkSettings().mergePersistedNetworkSettings();
                        Trace.trace(TRACE_MASKF, "Good completion erase restore.lst file ");
                        String upgradePath = mount_pointDOS + "/linos2/" + "restore.lst";
                        Trace.trace(TRACE_MASKF, "UpgradePath in final is :" + mount_pointDOS);
                        File f1DOS = new File(upgradePath);
                        if (f1DOS.exists()) {
                            Trace.trace(TRACE_MASKF, "File " + upgradePath + " exists");
                            Trace.trace(TRACE_MASKF, "Delete File " + upgradePath);
                            f1DOS.delete();
                            Trace.trace(TRACE_MASKF, "File " + upgradePath + " deleted");
                        } else {
                            Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                        }
                        this.good_completion = true;
                        Trace.trace(TRACE_MASKF, "Create busy dialog box for success");
                        LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                        LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG2);
                        this.tasklet.showBusyDialog(title, msg);
                        Trace.trace(TRACE_MASKF, "Sleep after Posting success busy box");
                        Thread.currentThread();
                        Thread.sleep(8000L);
                        this.tasklet.destroyBusyDialog();
                    }
                    if (upgrDeviceDOS != null) {
                        Trace.trace(TRACE_MASKF, "Unmount DOS partition");
                        upgrDeviceDOS.unmount();
                        upgrDeviceDOS.unlock();
                        upgrDeviceDOS = null;
                        Trace.trace(TRACE_MASKF, "Unmount DOS partition completed");
                    }
                    if (this.upgrDeviceHD != null) {
                        Trace.trace(TRACE_MASKF, "Unmount upgrade partition");
                        this.upgrDeviceHD.unmount();
                        this.upgrDeviceHD.unlock();
                        this.upgrDeviceHD = null;
                        Trace.trace(TRACE_MASKF, "Unmount upgrade partition completed");
                    }
                    if (this.upgrDeviceDVD != null) {
                        Trace.trace(TRACE_MASKF, "Unmount DVD partition");
                        this.upgrDeviceDVD.unmount();
                        this.upgrDeviceDVD.unlock();
                        this.upgrDeviceDVD = null;
                        Trace.trace(TRACE_MASKF, "Unmount DVD partition completed");
                    }
                    break block72;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "Exception in final cleanup for UpgradeDataRestoreTasklet.restoreupgradeData()");
                    message = 15;
                }
                break block72;
                {
                    catch (Exception exc) {
                        HException hexc = new HException(exc);
                        new FrameworkLog(_logInfo, 16483, hexc).log();
                        Trace.trace(TRACE_MASKF, "Caught Exception in restoreUpgradeData( )" + exc);
                        message = 15;
                        Object var21_32 = null;
                        Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataRestoreTasklet.restoreUpgradeData()");
                        try {
                            if (message == 13 && this.restore_lst) {
                                Trace.trace(TRACE_MASKF, "Good completion. Now merge network settings ");
                                NetworkSettings.getNetworkSettings().mergePersistedNetworkSettings();
                                Trace.trace(TRACE_MASKF, "Good completion erase restore.lst file ");
                                String upgradePath = mount_pointDOS + "/linos2/" + "restore.lst";
                                Trace.trace(TRACE_MASKF, "UpgradePath in final is :" + mount_pointDOS);
                                File f1DOS = new File(upgradePath);
                                if (f1DOS.exists()) {
                                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " exists");
                                    Trace.trace(TRACE_MASKF, "Delete File " + upgradePath);
                                    f1DOS.delete();
                                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " deleted");
                                } else {
                                    Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                                }
                                this.good_completion = true;
                                Trace.trace(TRACE_MASKF, "Create busy dialog box for success");
                                LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                                LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG2);
                                this.tasklet.showBusyDialog(title, msg);
                                Trace.trace(TRACE_MASKF, "Sleep after Posting success busy box");
                                Thread.currentThread();
                                Thread.sleep(8000L);
                                this.tasklet.destroyBusyDialog();
                            }
                            if (upgrDeviceDOS != null) {
                                Trace.trace(TRACE_MASKF, "Unmount DOS partition");
                                upgrDeviceDOS.unmount();
                                upgrDeviceDOS.unlock();
                                upgrDeviceDOS = null;
                                Trace.trace(TRACE_MASKF, "Unmount DOS partition completed");
                            }
                            if (this.upgrDeviceHD != null) {
                                Trace.trace(TRACE_MASKF, "Unmount upgrade partition");
                                this.upgrDeviceHD.unmount();
                                this.upgrDeviceHD.unlock();
                                this.upgrDeviceHD = null;
                                Trace.trace(TRACE_MASKF, "Unmount upgrade partition completed");
                            }
                            if (this.upgrDeviceDVD != null) {
                                Trace.trace(TRACE_MASKF, "Unmount DVD partition");
                                this.upgrDeviceDVD.unmount();
                                this.upgrDeviceDVD.unlock();
                                this.upgrDeviceDVD = null;
                                Trace.trace(TRACE_MASKF, "Unmount DVD partition completed");
                            }
                            break block72;
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "Exception in final cleanup for UpgradeDataRestoreTasklet.restoreupgradeData()");
                            message = 15;
                        }
                        break block72;
                    }
                }
                catch (Throwable throwable) {
                    Object var21_33 = null;
                    Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataRestoreTasklet.restoreUpgradeData()");
                    try {
                        if (message == 13 && this.restore_lst) {
                            Trace.trace(TRACE_MASKF, "Good completion. Now merge network settings ");
                            NetworkSettings.getNetworkSettings().mergePersistedNetworkSettings();
                            Trace.trace(TRACE_MASKF, "Good completion erase restore.lst file ");
                            String upgradePath = mount_pointDOS + "/linos2/" + "restore.lst";
                            Trace.trace(TRACE_MASKF, "UpgradePath in final is :" + mount_pointDOS);
                            File f1DOS = new File(upgradePath);
                            if (f1DOS.exists()) {
                                Trace.trace(TRACE_MASKF, "File " + upgradePath + " exists");
                                Trace.trace(TRACE_MASKF, "Delete File " + upgradePath);
                                f1DOS.delete();
                                Trace.trace(TRACE_MASKF, "File " + upgradePath + " deleted");
                            } else {
                                Trace.trace(TRACE_MASKF, "File " + upgradePath + " does not exist");
                            }
                            this.good_completion = true;
                            Trace.trace(TRACE_MASKF, "Create busy dialog box for success");
                            LocalizableText title = new LocalizableText(RES_BUNDLE_NAME, PANEL_TITLE);
                            LocalizableText msg = new LocalizableText(RES_BUNDLE_NAME, BUSY_MSG2);
                            this.tasklet.showBusyDialog(title, msg);
                            Trace.trace(TRACE_MASKF, "Sleep after Posting success busy box");
                            Thread.currentThread();
                            Thread.sleep(8000L);
                            this.tasklet.destroyBusyDialog();
                        }
                        if (upgrDeviceDOS != null) {
                            Trace.trace(TRACE_MASKF, "Unmount DOS partition");
                            upgrDeviceDOS.unmount();
                            upgrDeviceDOS.unlock();
                            upgrDeviceDOS = null;
                            Trace.trace(TRACE_MASKF, "Unmount DOS partition completed");
                        }
                        if (this.upgrDeviceHD != null) {
                            Trace.trace(TRACE_MASKF, "Unmount upgrade partition");
                            this.upgrDeviceHD.unmount();
                            this.upgrDeviceHD.unlock();
                            this.upgrDeviceHD = null;
                            Trace.trace(TRACE_MASKF, "Unmount upgrade partition completed");
                        }
                        if (this.upgrDeviceDVD != null) {
                            Trace.trace(TRACE_MASKF, "Unmount DVD partition");
                            this.upgrDeviceDVD.unmount();
                            this.upgrDeviceDVD.unlock();
                            this.upgrDeviceDVD = null;
                            Trace.trace(TRACE_MASKF, "Unmount DVD partition completed");
                        }
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "Exception in final cleanup for UpgradeDataRestoreTasklet.restoreupgradeData()");
                        message = 15;
                    }
                    throw throwable;
                }
            }
            this.restore_lst = true;
            message = mount_error;
            Trace.trace(TRACE_MASKF, "Mount error on DOS partition. Message is : " + message + ". Display message now ");
            HException hexc = new HException("DOS partition mount error");
            new FrameworkLog(_logInfo, 16484, hexc).log();
        }
        if (message != 13 && this.restore_lst) {
            Trace.trace(TRACE_MASKF, "Message is : " + message + ". Display message now ");
            this.restoreupgradeMessages(message);
            Trace.trace(TRACE_MASKF, "Display message done for restoreupgradeTasklet");
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataRestore.restoreUpgradeDataTasklet()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int restoreupgradeHarddrive() {
        byte[] buf = new byte[1024];
        int status = 0;
        Object zos = null;
        Object zis = null;
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.restoreupgradeHarddrive()");
        try {
            String upgradePath = BaseFileControl.getFilePath("UpgradeDataAllTowers.zip");
            Trace.trace(TRACE_MASKF, "upgradePath is : " + upgradePath);
            File fpath = new File(upgradePath);
            boolean path_Check = fpath.exists();
            if (fpath.exists()) {
                Trace.trace(TRACE_MASKF, "Path " + upgradePath + "exists");
                Trace.trace(TRACE_MASKF, "Delete files that start with UpgradeData");
                Trace.trace(TRACE_MASKF, "Except UpgradeDataAllTowers.zip");
                UpgradeDataFilter only = new UpgradeDataFilter();
                String[] foundFiles = fpath.list(only);
                for (int i = 0; i < foundFiles.length; ++i) {
                    Trace.trace(TRACE_MASKF, "Found file : " + upgradePath + foundFiles[i]);
                    Trace.trace(TRACE_MASKF, "foundfiles[i] is : " + foundFiles[i]);
                    if (foundFiles[i].equals("UpgradeDataAllTowers.zip") || foundFiles[i].equals("UpgradeDataTrace.lst")) {
                        Trace.trace(TRACE_MASKF, "Don't delete file : " + upgradePath + foundFiles[i]);
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "Delete file : " + upgradePath + foundFiles[i]);
                    File fpath_delete = new File(upgradePath + foundFiles[i]);
                    fpath_delete.delete();
                }
            }
            String fullFileNameZip = upgradePath + "UpgradeDataAllTowers.zip";
            Trace.trace(TRACE_MASKF, "fullFileNameZip is : " + fullFileNameZip);
            ZipFile zipfile = new ZipFile(fullFileNameZip);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                String zipEntryName = ze.getName();
                Trace.trace(TRACE_MASKF, "Zip entry name is :" + zipEntryName);
                if (!zipEntryName.equals("UpgradeDataAllTowers.zip")) {
                    int count;
                    Trace.trace(TRACE_MASKF, "Restore file with data: " + zipEntryName);
                    Trace.trace(TRACE_MASKF, "Open input stream");
                    InputStream zipIn = zipfile.getInputStream(ze);
                    Trace.trace(TRACE_MASKF, "Input stream openned");
                    Trace.trace(TRACE_MASKF, "Open File output stream");
                    FileOutputStream zipOut = new FileOutputStream(zipEntryName);
                    Trace.trace(TRACE_MASKF, "File Output stream openned");
                    byte[] buf_tmp = new byte[1024];
                    while ((count = zipIn.read(buf_tmp)) > 0) {
                        zipOut.write(buf_tmp, 0, count);
                    }
                    zipIn.close();
                    zipOut.close();
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Zip entry name is :" + zipEntryName + " Skip file copy");
            }
            zipfile.close();
            Trace.trace(TRACE_MASKF, "About to getUtility list from Tower");
            String fulltowerName = null;
            String versionNumber = null;
            this.implList = new ArrayList();
            ClassId towers = new ClassId("com.ibm.hwmca.fw.managed", "Tower");
            Set inventory = ManagedObjectManager.getManagedObjectManager().getInventory(towers);
            Trace.trace(TRACE_MASKF, "inventory size: " + inventory.size());
            Iterator iterator = inventory.iterator();
            while (iterator.hasNext()) {
                HwmcaObject obj = (HwmcaObject)iterator.next();
                if (!(obj instanceof Tower)) continue;
                Trace.trace(TRACE_MASKF, "found a tower");
                Trace.trace(TRACE_MASKF, "Create impl object");
                Object impl = ((Tower)obj).getInterfaceImpl(Class.forName(INTERFACE_NAME));
                Trace.trace(TRACE_MASKF, "impl object created");
                if (impl == null) continue;
                Trace.trace(TRACE_MASKF, "adding an impl");
                this.implList.add(impl);
                impl = null;
            }
            Trace.trace(TRACE_MASKF, "There are " + this.implList.size() + " tower(s) registered");
            Iterator i = this.implList.iterator();
            while (i.hasNext()) {
                Trace.trace(TRACE_MASKF, "Make UpgradeData class for tower being used");
                UpgradeData implClass = (UpgradeData)i.next();
                Trace.trace(TRACE_MASKF, "Create class class1 and get class name.");
                Class<?> class1 = implClass.getClass();
                String classNameRunning = class1.getName();
                fulltowerName = this.filePrefix + classNameRunning + "!";
                Trace.trace(TRACE_MASKF, "Full tower name is : " + fulltowerName);
                UpgradeDataClassFilter toweronly = new UpgradeDataClassFilter(fulltowerName);
                String[] foundFiles = fpath.list(toweronly);
                for (int i1 = 0; i1 < foundFiles.length; ++i1) {
                    Trace.trace(TRACE_MASKF, "Found file : " + upgradePath + foundFiles[i1]);
                    Trace.trace(TRACE_MASKF, "foundfiles[i1] is : " + foundFiles[i1]);
                    fulltowerName = upgradePath + foundFiles[i1];
                    Trace.trace(TRACE_MASKF, "Tower data found in zip file : " + fulltowerName);
                    int version_offset = fulltowerName.lastIndexOf("!");
                    Trace.trace(TRACE_MASKF, "Version offset is : " + version_offset);
                    versionNumber = fulltowerName.substring(version_offset + 1);
                    Trace.trace(TRACE_MASKF, "Version Number is : " + versionNumber);
                }
                Trace.trace(TRACE_MASKF, "Open Tower file input stream " + fulltowerName);
                FileInputStream zipTowerIn = new FileInputStream(fulltowerName);
                Trace.trace(TRACE_MASKF, "Tower file input stream " + fulltowerName + " opened");
                try {
                    Trace.trace(TRACE_MASKF, "Call restoreUpgrade(StreamNameIn)");
                    implClass.restoreUpgradeData(zipTowerIn, versionNumber);
                }
                catch (UpgradeDataException e2) {
                    Trace.trace(TRACE_MASKF, "Caught UpgradeData Exception in restoreupgradeHarddrive().restoreUpgradeData()" + e2);
                    if (e2.isCriticalDataError()) {
                        Trace.trace(TRACE_MASKF, "Critical Data error flag is set ");
                        status = 15;
                        new FrameworkLog(_logInfo, 16485, e2).log();
                    }
                    status = 0;
                }
                Trace.trace(TRACE_MASKF, "Return from restoreUpgrade(StreamNameIn)");
                Trace.trace(TRACE_MASKF, "Close Tower file input stream " + fulltowerName);
                ((InputStream)zipTowerIn).close();
                Trace.trace(TRACE_MASKF, "Tower file Input stream " + fulltowerName + " closed");
            }
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKF, "Caught Class Not Found Exception in saveupgradeHarddrive()" + e);
            status = 15;
            new FrameworkLog(_logInfo, 16486, e).log();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Caught IO Exception in restoreupgradeHarddrive()" + e);
            status = 15;
            new FrameworkLog(_logInfo, 16487, e).log();
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "Caught HException in restoreupgradeHarddrive()" + e);
            status = 15;
            new FrameworkLog(_logInfo, 16488, e).log();
        }
        finally {
            Trace.trace(TRACE_MASKF, "Doing final cleanup for UpgradeDataTasklet.restoreupgradeHarddrive()");
        }
        Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.restoreupgradeHarddrive()");
        return status;
    }

    public static boolean isrestorelst() {
        Trace.trace(TRACE_MASKT, "-> UpgradeDataTasklet.isrestorelst()");
        boolean restore_lst = false;
        int mount_error = 0;
        String restorePath = "/mnt/dos/linos2/";
        String restoreFile = restorePath + "restore.lst";
        File tmppath = new File(restorePath);
        boolean exists = tmppath.exists();
        Trace.trace(TRACE_MASKF, " UpgradeDataTasklet.isrestorelst() Dos partition mounted is " + exists);
        if (!exists) {
            mount_error = UpgradeDataRestoreTasklet.mountHardDriveDOS();
            if (mount_error == 0) {
                exists = false;
                File tmpfile = new File(restoreFile);
                exists = tmpfile.exists();
                Trace.trace(TRACE_MASKF, "check after mount for restore.lst is " + exists);
                if (exists) {
                    restore_lst = true;
                }
                try {
                    Trace.trace(TRACE_MASKF, "Unmount Dos partition");
                    upgrDeviceDOS.unmount();
                    upgrDeviceDOS.unlock();
                    upgrDeviceDOS = null;
                    Trace.trace(TRACE_MASKF, "Unmount of Dos partition done.");
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-> UpgradeDataTasklet.isrestorelst().Exception");
                    Trace.trace(TRACE_MASKT, "<-> Error message is : " + e.getMessage());
                }
            }
        } else {
            exists = false;
            File tmpfile1 = new File(restoreFile);
            exists = tmpfile1.exists();
            Trace.trace(TRACE_MASKF, "check for restore.lst no mount is " + exists);
            if (exists) {
                restore_lst = true;
            }
            Trace.trace(TRACE_MASKT, "<- UpgradeDataTasklet.isrestorelst()");
        }
        return restore_lst;
    }
}

